--3.1)	List the deptnum and total number of academics for CS departments, in alphabetical order of deptname.  CS departments are departments whose deptname contains the phrase "Computer ... Science" or “Computing … Science” in upper case or lower case letters.  You must use the NATURAL JOIN operator. 

SELECT * FROM DEPARTMENT NATURAL JOIN ACADEMIC
WHERE DESCRIP LIKE '%CS'
AND DEPTNAME LIKE '%Computer Science' OR '%Computing Science'
ORDER BY DEPTNAME;

--3.2)	List research fields where at least one academic is interested in. List the fieldnum, ID and title of these research fields. You must use a subquery.  
SELECT FIELD.FIELDNUM, FIELD.ID, FIELD.TITLE
FROM FIELD, INTEREST WHERE EXISTS (SELECT ACNUM AS '' FROM ACADEMIC WHERE ACADEMIC.ACNUM=INTEREST.ACNUM)
AND INTEREST.FIELDNUM=FIELD.FIELDNUM;

--3.3) Find papers that have three or more authors. Give the panum, title and number of authors for these papers. 
SELECT PAPER.PANUM, PAPER.TITLE, COUNT(AUTHOR.PANUM) AS NUMBER_OF_AUTHOR
FROM PAPER,AUTHOR
WHERE PAPER.PANUM=AUTHOR.PANUM
GROUP BY PAPER.PANUM
HAVING NUMBER_OF_AUTHOR>=3;

--3.4)	For EACH academic, compute the total number of papers s/he has written. Output should include the acnum and total number of papers for each academic. In particular, an academic without any papers should have zero(0) as number of papers in the output. You must use a JOIN operator. 
SELECT ACADEMIC.ACNUM, COUNT(PAPER.PANUM) AS NUMBER_OF_PAPERS
FROM ACADEMIC LEFT JOIN AUTHOR ON ACADEMIC.ACNUM=AUTHOR.ACNUM LEFT JOIN PAPER ON AUTHOR.PANUM=PAPER.PANUM
GROUP BY PAPER.PANUM;

--3.5)	Give the total number of academics that do not have research interests. You must use the NOT IN operator. 
 SELECT COUNT(ACNUM) AS TOTAL_NUMBER_OF_ACADEMIC FROM ACADEMIC WHERE ACNUM NOT IN (SELECT ACNUM FROM INTEREST);

--3.6)	Are there any research fields where less than 20, including zero, academics are interested in.  List the fieldnum, ID, title and number of interested academics for these research fields. 
 SELECT FIELD.FIELDNUM, FIELD.ID, FIELD.TITLE, COUNT(ACADEMIC.ACNUM) AS ACNUM
FROM FIELD RIGHT JOIN INTEREST ON FIELD.FIELDNUM-INTEREST.FIELDNUM 
RIGHT JOIN ACADEMIC ON INTEREST.ACNUM=ACADEMIC.ACNUM
GROUP BY FIELD.FIELDNUM, ACADEMIC.ACNUM
HAVING ACNUM>20;

--3.7)	Find the papers whose title contain the string 'data' and where at least one author is from the department with deptnum 100. List the panum and title of these papers. You must use the EXISTS operator. Ensure your query is case-insensitive. 
SELECT PAPER.PANUM, PAPER.TITLE FROM PAPER,AUTHOR, ACADEMIC 
WHERE EXISTS (SELECT DEPTNUM FROM DEPARTMENT WHERE ACADEMIC.DEPTNUM=DEPARTMENT.DEPTNUM
AND DEPTNUM=100)
AND PAPER.PANUM=AUTHOR.PANUM
AND AUTHOR.ACNUM=ACADEMIC.ACNUM
AND PAPER.TITLE LIKE '%data%'
GROUP BY PAPER.PANUM
ORDER BY PAPER.PANUM; 

--3.8)	Return the research interest that has the largest number of interested academics. You must not use MAX. Note: An SQL query that lists all research interests in decreasing order of their total number of interested academics is incorrect. 
SELECT ACADEMIC.FAMNAME , COUNT(ACADEMIC.ACNUM) AS ACNUM, INTEREST.FIELDNUM 
FROM INTEREST LEFT JOIN ACADEMIC ON INTEREST.ACNUM=ACADEMIC.ACNUM
GROUP BY ACADEMIC.ACNUM
ORDER BY ACNUM DESC LIMIT 0,1;

--3.9)	The following SQL query is intended to find academics (acnum) who are ONLY interested in "Data" (descrip) fields.  But it is incorrect. Give the correct SQL query.
--select acnum
--from interest
--where upper(descrip) like '%DATA%'

SELECT *
FROM interest
WHERE UPPER(descrip) LIKE '%DATA%'
GROUP BY ACNUM, FIELDNUM
ORDER BY ACNUM;

--3.10)	Consider the SQL query given below, give the English explanation for the output of a) the subquery, and b) the whole SQL query. Literal explanation will receive zero mark. 
select distinct AC1.givename, AC1.famname, AC2.givename, AC2.famname
from academic AC1, author AU1, academic AC2, author AU2
where AC1.acnum=AU1.acnum
    and AC2.acnum=AU2.acnum
    and AU1.panum=AU2.panum
    and AU2.acnum>AU1.acnum
    and not exists
        (select *
        from Interest I1, Interest I2
        where I1.acnum =AC1.acnum
            and I2.acnum=AC2.acnum
            and I1.fieldnum=I2.fieldnum);*/

--ans: - list the different academic that have co-authored papers with other other academics that not interest research with other interest research.list the academic in pair listing first name and last name.