/*
 * Assignment5.cpp
 *
 *  Created on: Apr 17, 2018
 *      Author: Tan Nguyen
 *      Email: thanhtanpc@gmail.com
 *      Skype: thanh_tan_pc
 *      Reference: Using lib json parser: https://github.com/azadkuh/nlohmann_json_release
 */

#include <iostream>
#include <iomanip>
#include <fstream>
#include <string>
#include <vector>
#include "json.hpp"
using namespace std;

using Json = nlohmann::json;

// Prototype function
void PrintUsage(string programname);
bool CheckSortType(string sortType);
Json ReadJsonFile(string);
void WriteDatabaseToFile(Json, string, string);

vector<vector<string>> JsonToVector(Json);
vector<vector<string>> SortDatabaseBySortType(vector<vector<string>>, string);
vector<vector<string>> SortVector(vector<vector<string>>);

int main(int argc, char *argv[])
{
    if (argc != 5)
    {
        PrintUsage(argv[0]);
        return 1;
    }
    if (strncmp(argv[1], "-s", 2) != 0)
    {
        cout << "Invalid Option notation." << endl;
        PrintUsage(argv[0]);
        return 1;
    }
    if (!CheckSortType(argv[2]))
    {
        cout << "Invalid sort type." << endl;
        PrintUsage(argv[0]);
        return 1;
    }
    Json database = ReadJsonFile(argv[3]);
    cout << "Read data from json file: " << argv[2] << " success." << endl;
    WriteDatabaseToFile(database, argv[4], argv[2]);
    cout << "Write table with name: " << argv[4] << " success." << endl;
    return 0;
}

/**
 * Print Usage
 */
void PrintUsage(string programname)
{
    cout << "Usage: [path to your program ] [option notation] [field to be sorted] [inputfile path] [outputfile path]" << endl;
    cout << "Example: " << programname << " -s id sample.json sortid.table" << endl;
}

/**
 * Check invalid sort type from argument
 */
bool CheckSortType(string sortType)
{
    if (sortType == "id" || sortType == "name" || sortType == "batter" || sortType == "topping")
        return true;
    return false;
}

/**
 * Write Json database to file with sort
 */
void WriteDatabaseToFile(Json database, string outfile, string outSort)
{

    // Convert Json to vector store
    vector<vector<string>> databaseVector = JsonToVector(database);
    // Sort database
    databaseVector = SortDatabaseBySortType(databaseVector, outSort);

    //output stream to file
    ofstream out(outfile);

    if (out.is_open())
    {
        if (outSort == "id")
        {
            out << setw(70) << "|  id  |    type    |    name    |     batter     |           topping          |" << endl;
            out << setw(70) << "--------------------------------------------------------------------------------" << endl;

            for (unsigned int it = 0; it < databaseVector.size(); it++)
            {
                out << "| " << setw(4) << left << databaseVector[it][0] << " |" << setw(12) << right << databaseVector[it][1] << "|" << setw(12) << right
                        << databaseVector[it][2] << "|" << setw(16) << right << databaseVector[it][3] << "|" << setw(28) << right << databaseVector[it][4]
                        << "|" << endl << setw(70) << "--------------------------------------------------------------------------------" << endl;
            }
        }

        else if (outSort == "type")
        {
            out << setw(70) << "|    type    |  id  |    name    |     batter     |           topping          |" << endl;
            out << setw(70) << "--------------------------------------------------------------------------------" << endl;

            for (unsigned int it = 0; it < databaseVector.size(); it++)
            {
                out << "|" << setw(12) << right << databaseVector[it][0] << "| " << setw(4) << left << databaseVector[it][1] << " |" << setw(12) << right
                        << databaseVector[it][2] << "|" << setw(16) << right << databaseVector[it][3] << "|" << setw(28) << right << databaseVector[it][4]
                        << "|" << endl << setw(70) << "--------------------------------------------------------------------------------" << endl;
            }
        }

        else if (outSort == "name")
        {
            out << setw(70) << "|    name    |    type    |  id  |     batter     |           topping          |" << endl;
            out << setw(70) << "--------------------------------------------------------------------------------" << endl;

            for (unsigned int it = 0; it < databaseVector.size(); it++)
            {
                out << "|" << setw(12) << right << databaseVector[it][0] << "|" << setw(12) << right << databaseVector[it][1] << "| " << setw(4) << left
                        << databaseVector[it][2] << " |" << setw(16) << right << databaseVector[it][3] << "|" << setw(28) << right << databaseVector[it][4]
                        << "|" << endl << setw(70) << "--------------------------------------------------------------------------------" << endl;
            }
        }

        else if (outSort == "batter")
        {
            out << setw(70) << "|     batter     |    type    |    name    |  id  |           topping          |" << endl;
            out << setw(70) << "--------------------------------------------------------------------------------" << endl;

            for (unsigned int it = 0; it < databaseVector.size(); it++)
            {
                out << "|" << setw(16) << right << databaseVector[it][0] << "|" << setw(12) << right << databaseVector[it][1] << "|" << setw(12) << right
                        << databaseVector[it][2] << "| " << setw(4) << left << databaseVector[it][3] << " |" << setw(28) << right << databaseVector[it][4]
                        << "|" << endl << setw(70) << "--------------------------------------------------------------------------------" << endl;
            }
        }

        else if (outSort == "topping")
        {
            out << setw(70) << "|           topping          |    type    |    name    |     batter     |  id  |" << endl;
            out << setw(70) << "--------------------------------------------------------------------------------" << endl;

            for (unsigned int it = 0; it < databaseVector.size(); it++)
            {
                out << "|" << setw(28) << right << databaseVector[it][0] << "|" << setw(12) << right << databaseVector[it][1] << "|" << setw(12) << right
                        << databaseVector[it][2] << "|" << setw(16) << right << databaseVector[it][3] << "| " << setw(4) << left << databaseVector[it][4]
                        << " |" << endl << setw(70) << "--------------------------------------------------------------------------------" << endl;
            }
        }
        out.close();
    } else
    {
        cout << "Can NOT to open for write the table. Please check your system." << endl;
        exit(1);
    }
}
/**
 * Read JSON file and store to Json type
 */
Json ReadJsonFile(std::string filename)
{
    Json database;
    // Check input format
    if (filename.find(".json") < filename.size())
    {
        ifstream SampleInput(filename);
        if (SampleInput.is_open())
        {
            SampleInput >> database;
            SampleInput.close();
        } else
        {
            cout << "JSON file can NOT open. Exit program!" << endl;
            exit(1);
        }
    } else
    {
        cout << "Input file is not JSON format. Please take care!!!" << endl;
        exit(1);
    }
    return database;
}

/**
 * Convert database from json type to vector
 */
vector<vector<string>> JsonToVector(Json database)
{

    vector<vector<string>> databaseVector;
    unsigned i = 0;
    for (const Json &item : database["items"]["item"])
    {
        for (const Json &batter : item["batters"]["batter"])
        {
            for (const Json &topping : item["topping"])
            {
                databaseVector.push_back(vector<string>());
                databaseVector[i].push_back(item["id"]);
                databaseVector[i].push_back(item["type"]);
                databaseVector[i].push_back(item["name"]);
                databaseVector[i].push_back(batter["type"]);
                databaseVector[i].push_back(topping["type"]);
                i++;
            }
        }
    }
    return databaseVector;
}

/**
 * Sort the vector database base on sort type
 */
vector<vector<string>> SortDatabaseBySortType(vector<vector<string>> databaseVector, string sortType)
{

    unsigned int typeIndex = 0;

    if (sortType == "id")
    {
        return databaseVector;
    }

    else if (sortType == "type")
        typeIndex = 1;

    else if (sortType == "name")
        typeIndex = 2;

    else if (sortType == "batter")
        typeIndex = 3;

    else if (sortType == "topping")
        typeIndex = 4;
    //Swaps the type index to the begin
    for (size_t it = 0; it < databaseVector.size(); it++)
    {
        string temp = databaseVector[it][0];
        databaseVector[it][0] = databaseVector[it][typeIndex];
        databaseVector[it][typeIndex] = temp;
    }
    return SortVector(databaseVector);
}

/**
 * Sort vector database base on the first element
 */
vector<vector<string>> SortVector(vector<vector<string>> databaseVector)
{

    unsigned int min;

    for (unsigned int pos = 0; pos < databaseVector.size(); pos++)
    {
        min = pos;

        for (unsigned int it = pos; it < databaseVector.size(); it++)
        {
            if (databaseVector[min][0] > databaseVector[it][0])
            {
                min = it;
            }
        }
        vector<string> temp = databaseVector[pos];
        databaseVector[pos] = databaseVector[min];
        databaseVector[min] = temp;
    }
    return databaseVector;
}

